/** @file   sentrygunai.cpp
 * @brief   Implementation of SentryGunAI - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "sentrygunai.h" // class's header file
#include "warglobals.h"
#include "utils.h"
#include "sentrygun.h"

namespace WeWantWar {


// class constructor
SentryGunAI::SentryGunAI( GameObject* pObject) :
  AIController( pObject, WarGlobals::pObjTable->pPlayer ),
  m_viewDistance( 500 ),
  m_shootingRange( 500 )
{
  AIController::m_visualRange = 500;
  AIController::m_attackRange = 500;
}

// class destructor
SentryGunAI::~SentryGunAI()
{
	// insert your code here
}



/** Updates this controller
 */
void SentryGunAI::updateAI( bool seeTarget, float dist )
{
  // Check if the current controls should be considered valid.
  this->reset();
  
  // Check if target is within the viewing range.
  if ( this->withinVisualRange() == false ) {
    // Target is too far away so we do noting
    this->setCounter( 20 + rand() % 20 );
    return;
  }
  
  // Target is within our viewing range. Can we see him?
  if ( seeTarget == false ) {
    // We can't see the target.
    this->setCounter( 20 + rand() % 20 );
    return;
  }
  
  if ( Utils::isFacingObject( m_pObject, m_pTarget, 25 ) == true ) {
    // Now we can see the target and our gun is pointing toward him.
    // If our weapon is ready to shoot, we shoot.
    SentryGun* pO = dynamic_cast<SentryGun*>( m_pObject );
    if ( pO->reloading() == false ) {
      this->shoot() = 1;
      if ( pO->gunType() == SentryGun::T_MACHINEGUN ) {
        this->turn() = (rand() % 3) - 1;
      } else {
        this->turn() = 0;
      }
      this->setCounter( 15 + rand() % 6 );
      return;
    }
    this->setCounter( 5 + rand() % 6 );
    
  } else {
    // We're not facing him. We turn
    int d = Utils::findTurningDir( m_pObject->position(),
                                   m_pTarget->position(),
                                   m_pObject->angle() );
    this->turn() = d;
    this->setCounter( 2 );
  }
}


} // end of namespace

/**
 * Version history
 * ===============
 * $Log: sentrygunai.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:44  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:37+02  lamminsa
 * Initial revision
 *
 */
 
